﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-12</title>
		<script runat="server">

            const string kodPracownika = "";
		    
            class Z12Info : IComparable<Z12Info> {

                readonly Pracownik pracownik;
                readonly PracHistoria historia;
                readonly int rok;

                FromTo Październik {
                    get { return new YearMonth(rok, 10).ToFromTo(); }
                }

                FromTo CałyRok {
                    get { return FromTo.Year(rok); }
                }

                public Z12Info(Pracownik pracownik, int rok) {
                    this.pracownik = pracownik;
                    this.rok = rok;
                    this.historia = pracownik[Październik.To];
                }
                public Pracownik Pracownik {
                    get { return pracownik; }
                }




                //SLAWEK


                public object PracownikaKod
                {
                    get { return pracownik.Kod; }
                }

                public object PracownikaImie
                {
                    get { return pracownik.Imie; }
                }

                public object PracownikaNazwisko
                {
                    get { return pracownik.Nazwisko; }
                }

                //KONIEC SLAWKA           
                
                
                
                
                
                public int CompareTo(Z12Info other) {
                    return pracownik.Kod.CompareTo(other.pracownik.Kod);
                }

                Periods OkresyZatrudnienia(FromTo okres) {
                    Periods okresy = Periods.Empty;
                    foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                        if (ph.Etat.EfektywnyOkres != FromTo.Empty && PoprawneZatrudnienie(ph))
                            okresy += ph.Etat.EfektywnyOkres;
                    return (okresy * okres).ToFlat();
                }
                
                public bool Wchodzi {
                    get {
                        Periods okresy = OkresyZatrudnienia(Październik) * Październik;
                        return okresy == Październik && KontrolaNieobecności();
                    }
                }

                bool PoprawneZatrudnienie(PracHistoria ph) {
                    return ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.NieDotyczy;
                }

                bool KontrolaNieobecności() {
                    Periods okrnie = Periods.Empty;
                    Periods urlbezp = Periods.Empty;

                    KalkulatorPracy kalk = pracownik.Czasy.KalkPracy;
                    foreach (OkresNieobecności n in kalk.Nieobecnosci(Październik, true))
                        switch (n.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopMacierzyński:
                            case PrzyczynaNieobecnosci.UrlopWychowawczy:
                            case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                                okrnie += n.Okres;
                                return false;
                            case PrzyczynaNieobecnosci.UrlopBezpłatny:
                                urlbezp += n.Okres;
                                break;
                            //TODO: Case Urlop profilaktyczny:
                            case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                                return false;
                        }

                    return urlbezp.Days < 10 && (Periods.New(Październik) - okrnie) != Periods.Empty;
                }

                //------------------- GRUPA B ----------------------

                public string KodWykonywanegoZawodu {   //B3
                    get {
                        string s = historia.Etat.KodWykonywanegoZawodu.ToString();
                        if (s == "0")
                            s = "";
                        else if (s.Length > 4)
                            s = s.Substring(0, 4);
                        return s;
                    }
                }

                public int Płeć {                       //B4
                    get { return historia.Plec == PłećOsoby.Kobieta ? 2 : 1; }
                }

                public int RodzajUmowyOPracę {          //B6
                    get {
                        switch (historia.Etat.TypUmowy) {
                            case TypUmowyOPrace.NaCzasNieokreślony:
                                return 1;
                            case TypUmowyOPrace.NaCzasOkreślony:
                                return 2;
                        }
                        return 3;
                    }
                }

                public int RokUrodzenia {               //B7
                    get { return historia.Urodzony.Data.Year % 100; }
                }

                public object StażPracyOgółem {              //B8
                    get { return StażPracy(pracownik.StażPracy(Październik.To, pracownik.Module.DefPodstawStazu.Zatrudnienie)); }
                }

                public object StażPracyWFirmie {       //B9
                    get { return StażPracy (pracownik.StażPracy (Październik.To)); }
                }





                
                //SLAWEK

                
                public object PoziomWyksztalcenia
                {
                    get
                    {
                        switch (historia.Wyksztalcenie.Kod)
                        {
                            case KodWyksztalcenia.Policealne:
                                return 3;
                            case KodWyksztalcenia.NiepelnePodstawowe:
                                return 8;
                            case KodWyksztalcenia.Podstawowe:
                                return 8;
                            case KodWyksztalcenia.ZasadniczeZawodowe:
                                return 6;
                            case KodWyksztalcenia.SrednieZawodowe:
                                return 4;
                            case KodWyksztalcenia.SrednieOgolnoksztalcace:
                                return 5;
                            case KodWyksztalcenia.Licencjat:
                                return 2;
                            case KodWyksztalcenia.Wyzsze:
                                return 1;
                            case KodWyksztalcenia.NieDotyczy:
                                return "Błąd - wpisz dane";
                        }
                        return "Błąd - wpisz dane";
                    }
                    
                    
                    
                }


                public string JakieWyksztalcenie
                {
                    get
                    {
                        string JakWyksztalcony = historia.Wyksztalcenie.StopienNaukowy.ToString();
                        if (JakWyksztalcony == "1")
                            JakWyksztalcony = "1";
                        else if
                            (JakWyksztalcony == "2")
                            JakWyksztalcony = "2";
                        else
                            JakWyksztalcony = PoziomWyksztalcenia.ToString();
                        return JakWyksztalcony;
                    }
                }
        
                
                
          
                    
                    
                // SALWEK - KONIEC
                
                
                
                
                
                //------------------- TOOLS ------------------------

                void LiczCzas(FromTo okres, out Time nominalny, out Time pomniejszenia, out Time plus, out Time minus) {
                    nominalny = Time.Zero;
                    pomniejszenia = Time.Zero;
                    plus = Time.Zero;
                    minus = Time.Zero;

                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat)
                            foreach (WypSkladnik składnik in element.Skladniki)
                                switch (składnik.Rodzaj) {
                                    case RodzajSkładnikaWypłaty.Główny:
                                        nominalny += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.Korekta:
                                        break;
                                    case RodzajSkładnikaWypłaty.PomniejszenieProp:
                                    case RodzajSkładnikaWypłaty.Pomniejszenie130:
                                    case RodzajSkładnikaWypłaty.PomniejszenieZaDzień:
                                    case RodzajSkładnikaWypłaty.PomniejszeniePropZero:
                                        WypSkladnikPomniejszenie sklp = (WypSkladnikPomniejszenie)składnik;
                                        DefinicjaNieobecnosci definicja = sklp.Nieobecnosc.Definicja;
                                        if (definicja.Rozliczenie == RozliczenieNieobecnosci.Brak && definicja.PomniejszaCzasPracy)
                                            pomniejszenia += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.PomniejszenieStorno:
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaPlus:
                                        plus += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaMinus:
                                        minus += składnik.Czas;
                                        break;
                                    case RodzajSkładnikaWypłaty.OdchyłkaAkordMinus:
                                        break;
                                }
                }

                decimal SumaElementów(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    decimal wartość = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            wartość += element.Wartosc;
                    return wartość;
                }


                decimal SumaOdchyłekPlus(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    decimal wartość = 0;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            foreach (WypSkladnik skl in element.Skladniki)
                                if (skl is WypSkladnikOdchyłka.Plus)
                                    wartość += skl.Wartosc;
                    return wartość;
                }

                Time SumaCzasuElementów(FromTo okres, string pozycja) {
                    pozycja = pozycja + "|";
                    Time czas = Time.Zero;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1)
                            czas += element.Czas;
                    return czas;
                }
                
                Time CzasNieprzepracowany(FromTo okres, string pozycja) {
                    if (pozycja!="")
                        pozycja = pozycja + "|";
                    Time czas = Time.Zero;
                    foreach (WypElement element in pracownik.Elementy[okres])
                        if (element is WypElementEtat)
                            foreach (WypSkladnik składnik in element.Skladniki) {
                                WypSkladnikPomniejszenie skłpomn = składnik as WypSkladnikPomniejszenie;
                                Nieobecnosc nieobecność = skłpomn == null ? null : skłpomn.Nieobecnosc;
                                if (nieobecność != null && (pozycja=="" || nieobecność.Definicja.Features.GetString("GUS Z12").IndexOf(pozycja) != -1))
                                    czas += skłpomn.Czas;
                            }
                    return -czas;
                }

                decimal WskaźnikWymiaruCzasuPracy(FromTo okres) {
                    Time normaMies = Pracownik.Czasy.Norma(new YearMonth(okres.To).ToFromTo()).Czas;
                    Time praca = Pracownik.Czasy.Norma(okres).Czas - CzasNieprzepracowany(okres, "D12") - SumaCzasuElementów(okres, "D12");
                    return Soneta.Tools.Math.RoundCy((1m * praca.TotalMinutes) / normaMies.TotalMinutes);
                }
                
                //------------------- GRUPA C ----------------------

              
             /*   public object CzasOpłaconyRazem10 {                     //C1
                    get {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(Październik, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(nominalny + pomniejszenia + plus + minus, 2);
                    }
                 
                }
                
             */




                public object CzasOpłaconyRazem10
                {                     //C1
                    get
                    {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(Październik, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(nominalny + pomniejszenia + plus + minus, 2);
                    }
                }
                
                
            
                
                
                public object CzasOpłaconyNominalny10 {                 //C2
                    get {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(Październik, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(nominalny + pomniejszenia + plus + minus, 2);
                    }
                }
                public object CzasOpłaconyNadgodziny10 {                //C3
                    get {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(Październik, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(Time.Max(plus - minus, Time.Zero), 2);
                    }
                }
                public decimal WskaźnikWymiaruCzasuPracy10 {                   //C4
                    get { return WskaźnikWymiaruCzasuPracy(Październik); }
                }                
                public decimal WynagrOsobowe10 {                              //C5
                    get { return SumaElementów(Październik, "C5"); }
                }        
                public decimal WynagrZasadnicze10 {                           //C6
                    get { return SumaElementów(Październik, "C6") - SumaOdchyłekPlus(Październik, "C6"); }
                }
                public decimal WynagrNadliczbowe10 {                          //C7
                    get { return SumaElementów(Październik, "C7") + SumaOdchyłekPlus(Październik, "C6"); }
                }
                public decimal WynagrZmianowe10 {                             //C8
                    get { return SumaElementów(Październik, "C8"); }
                }
                public decimal WynagrStażPracy10 {                            //C9
                    get { return SumaElementów(Październik, "C9"); }
                }
                public decimal WynagrPremieNagrody10 {                        //C10
                    get { return SumaElementów(Październik, "C10"); }
                }
                public decimal WynagrHonoraria10 {                           //C11
                    get { return SumaElementów(Październik, "C11"); }
                }

                //------------------- GRUPA D ----------------------

                public object CzasOpłaconyRazemRok {                    //D1
                    get {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(CałyRok, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(nominalny + pomniejszenia + plus + minus, 2);
                    }
                }


                
                
                public object CzasOpłaconyNadgodzinyRok {               //D2
                    get {
                        Time nominalny, pomniejszenia, plus, minus;
                        LiczCzas(CałyRok, out nominalny, out pomniejszenia, out plus, out minus);
                        return Czas(Time.Max(plus - minus, Time.Zero), 2);
                    }
                }
                public decimal WskaźnikWymiaruCzasuPracyRok {           //D3
                    get {
                        Periods okresy = OkresyZatrudnienia(CałyRok);
                        okresy = okresy.BreakByMonth();
                        decimal wskaźnik = 0;
                        foreach (FromTo okres in okresy)
                            wskaźnik += WskaźnikWymiaruCzasuPracy(okres);
                        return wskaźnik;                            
                    }
                }
                
                
                
                
                

                
                
                
                public decimal WynagrOsoboweRok {                       //D4
                    get { return SumaElementów(CałyRok, "D4"); }
                }
                public decimal WynagrNadliczboweRok {                   //D5
                    get { return SumaElementów(CałyRok, "D5") + SumaOdchyłekPlus(CałyRok, "C6"); }
                }
                public decimal WynagrPremieNagrodyRok {                 //D6
                    get { return SumaElementów(CałyRok, "D6"); }
                }
                public decimal WynagrHonorariaRok {                     //D7
                    get { return SumaElementów(CałyRok, "D7"); }
                }
                public decimal WynagrTrzynastkaRok {                    //D8
                    get { return SumaElementów(CałyRok, "D8"); }
                }
                public decimal WynagrUdziałWZyskuRok {                  //D9
                    get { return SumaElementów(CałyRok, "D9"); }
                }
                public object CzasNieprzepracowanyOgółemRok {           //D10
                    get { return Czas(CzasNieprzepracowany(CałyRok, ""), 0); }
                }
                public object UrlopyWypoczynkoweRok {                   //D11
                    get { return Czas(CzasNieprzepracowany(CałyRok, "D11") + SumaCzasuElementów(CałyRok, "D11"), 0); }
                }
                public object CzasNieopłaconyRok {                      //D12
                    get { return Czas(CzasNieprzepracowany(CałyRok, "D12") + SumaCzasuElementów(CałyRok, "D12"), 0); }
                }
            }

            static bool debug = false;
		        
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year - 1;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

            void dc_ContextLoad(Object sender, EventArgs e) {
                Log log = new Log();
                ReportHeader["ROK"] = pars.Rok.ToString();

                List<Z12Info> lista = new List<Z12Info>();
                IEnumerable st = KadryModule.GetInstance(dc).Pracownicy.WgKodu;
                int c = 0;
                foreach (Pracownik pracownik in st)
                    c++;
                int l = 0;
                foreach (Pracownik pracownik in st)
                    if (kodPracownika == "" || pracownik.Kod == kodPracownika) {
                        log.WriteLine(pracownik);
                        log.WriteLine(new Percent(l++, c));
                        Z12Info z12info = new Z12Info(pracownik, pars.Rok);
                        if (z12info.Wchodzi) {
                            lista.Add(z12info);
                            //if (lista.Count >= 10)
                            //    break;
                        }
                    }

                lista.Sort();

                Grid1.DataSource = lista;
            }

            public static object StażPracy(StazPracy stp) {
                stp = stp.Normalizuj();
                if (debug)
                    return stp;
                decimal result = Soneta.Tools.Math.Round(stp.Lata + stp.Miesiace / 12m, 1);
                return result;
            }

            public static object Czas(Time t, int precyzja) {
                if (debug)
                    return t;
                return Soneta.Tools.Math.Round(t.TotalHours, precyzja);
            }

            public decimal Tys(decimal value) {
                if (debug)
                    return value;
                return Soneta.Tools.Math.Round(value / 1000m, 1);
            }


            static void Msg(object value) {
            }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
				<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad" style="top: 0px"></ea:DataContext>
				<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-12|</strong>Rok: <strong>%ROK%"
					runat="server"></eb:ReportHeader>
        <ea:Grid id="Grid1" runat="server" Sort="Pracownik.NazwiskoImię,Nazwa">
            <Columns>
                <ea:GridColumn Width="3" Align="Right" DataMember="#" Caption="Lp." runat="server"></ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Kod Pracownika" ColSpan="2" DataMember="PracownikaKod">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Imię Pracownika" ColSpan="2" DataMember="PracownikaImie">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Nazwisko Pracownika" ColSpan="2" DataMember="PracownikaNazwisko">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B1" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B2" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B3" DataMember="KodWykonywanegoZawodu" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B4" DataMember="Płeć" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B5" DataMember="JakieWyksztalcenie" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B6" DataMember="RodzajUmowyOPracę" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B7" DataMember="RokUrodzenia" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B8" DataMember="StażPracyOg&#243;łem" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="B9" DataMember="StażPracyWFirmie" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C1" DataMember="CzasOpłaconyRazem10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C2" DataMember="CzasOpłaconyNominalny10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C3" DataMember="CzasOpłaconyNadgodziny10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C4" DataMember="WskaźnikWymiaruCzasuPracy10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C5" DataMember="WynagrOsobowe10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C6" DataMember="WynagrZasadnicze10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C7" DataMember="WynagrNadliczbowe10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C8" DataMember="WynagrZmianowe10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C9" DataMember="WynagrStażPracy10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C10" DataMember="WynagrPremieNagrody10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="C11" DataMember="WynagrHonoraria10" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D1" DataMember="CzasOpłaconyRazemRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D2" DataMember="CzasOpłaconyNadgodzinyRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D3" DataMember="WskaźnikWymiaruCzasuPracyRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D4" DataMember="WynagrOsoboweRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D5" DataMember="WynagrNadliczboweRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D6" DataMember="WynagrPremieNagrodyRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D7" DataMember="WynagrHonorariaRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D8" DataMember="WynagrTrzynastkaRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D9" DataMember="WynagrUdziałWZyskuRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D10" DataMember="CzasNieprzepracowanyOg&#243;łemRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D11" DataMember="UrlopyWypoczynkoweRok" HideZero="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="D12" DataMember="CzasNieopłaconyRok" HideZero="True">
                </ea:GridColumn>


                
            </Columns>
        </ea:Grid>
				<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>
